-- mods/cobalt/init.lua
-- ===================
-- See LICENSE.txt for licensing and README.md for other information.

-- load support for intllib
local modpath = minetest.get_modpath(minetest.get_current_modname())
local S = minetest.get_translator("cobalt")

-- Lapis Lazuli Ore
minetest.register_node("cobalt:stone_with_cobalt", {
	description = S("cobalt Ore"),
	tiles = {"default_stone.png^cobalt_mineral_cobalt.png"},
	is_ground_content = true,
	groups = {cracky=2},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'cobalt:cobalt 2'},  --The first and second drops ever
			},
			{
				items = {'cobalt:cobalt'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'cobalt:cobalt'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'cobalt:cobalt'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

-- Lapis Item
minetest.register_craftitem("cobalt:cobalt", {
	description = S("cobalt"),
	inventory_image = "cobalt.png",
})


minetest.register_node("cobalt:cobaltblock", {
	description = S("cobalt Block"),
	tiles = {"cobalt_cobaltblock.png"},
	is_ground_content = true,
	groups = {cracky = 1, level = 2},
	sounds = default.node_sound_stone_defaults(),
})


minetest.register_craft({
	output = 'cobalt:cobalt',
	recipe = {
		{'cobalt:cobalt', 'cobalt:cobalt', 'cobalt:cobalt'},
		{'cobalt:cobalt', 'cobalt:cobalt', 'cobalt:cobalt'},
		{'cobalt:cobalt', 'cobalt:cobalt', 'cobalt:cobalt'},
	}
})

-- Lapis Items from Lapis Block Crafting
minetest.register_craft({
	output = 'cobalt:cobalt 9',
	recipe = {
		{'cobalt:cobalt'},
	}
})

-- Ore generation
-- -128 <-> -255
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "cobalt:stone_with_cobalt",
	wherein        = "default:stone",
	clust_scarcity = 16 * 16 * 16,
	clust_num_ores = 5,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = 31000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "cobalt:stone_with_cobalt",
	wherein        = "default:stone",
	clust_scarcity = 15 * 15 * 15,
	clust_num_ores = 6,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = 31000,
})


